
extern const unsigned char tiles[];	//Pointer to tiles in the library
extern const unsigned char tiles_set1[];	//Pointer to self tiles
extern const unsigned char tiles_set2[];	//Pointer to self tiles
extern const unsigned char tiles_set3[];	//Pointer to self tiles
extern const unsigned char tiles_set4[];	//Pointer to self tiles

extern const unsigned char tiles_comp1[];	//Pointer to self tiles
extern const unsigned char tiles_comp2[];	//Pointer to self tiles
extern const unsigned char tiles_comp3[];	//Pointer to self tiles
extern const unsigned char tiles_comp4[];	//Pointer to self tiles
extern const unsigned char tiles_comp5[];	//Pointer to self tiles
extern const unsigned char tiles_comp6[];	//Pointer to self tiles
extern const unsigned char tiles_comp7[];	//Pointer to self tiles



void load_tilemap(void)
{
             switch(screen_n) //Main set
                {
                    case 0:
                    case 1:
                    case 2:

                    case 4:
                    case 5:
                    case 6:
                    case 11:memcpy(tiles,tiles_set1,TILESET_LENGHT);  // 0-12 = 13 tiles
                            break;

                    case 7:memcpy(tiles,tiles_set1,48);  // 3  tiles
                           memcpy(tiles+64,tiles_set2+64,16);
                                    break;

                    case 3:
                    case 8: memcpy(tiles,tiles_set2,TILESET_LENGHT);  // 0-12 = 13 tiles
                            break;
                    default:
                            break;

                }

             switch(screen_n) //Secondary set
                {
                    case 0:
                           memcpy(tiles+TILESET_LENGHT+256,tiles_comp2,64);  // 4 tiles --  Trash Container
                           memcpy(tiles+TILESET_LENGHT+320,tiles_comp6,64);  // 4 tiles --  Trash Container

                           break;

                    case 1:
                    case 11:
                            memcpy(tiles+TILESET_LENGHT,tiles_comp4,256);  // 10 tiles -- PArty control
                            memcpy(tiles+TILESET_LENGHT+320,tiles_comp6,64);  // 4 tiles --  Control party
                            break;

                    case 2:memcpy(tiles+TILESET_LENGHT,tiles_comp1,256);  // 16 tiles   -- Pizza store
                           memcpy(tiles+TILESET_LENGHT+256,tiles_comp2,64);  // 4 tiles --  Trash Container
                           memcpy(tiles+TILESET_LENGHT+320,tiles_comp6,64);  // 4 tiles --  Control party
                           break;

                    case 4: memcpy(tiles+TILESET_LENGHT,tiles_comp2,64);  // 4 tiles --  Trash Container
                            memcpy(tiles+TILESET_LENGHT+64,tiles_comp7,256);
                            break;
                    case 5:memcpy(tiles+TILESET_LENGHT,tiles_comp5,256);  // 16 tiles   -- Mechania stairs
                           memcpy(tiles+TILESET_LENGHT+256,tiles_comp2,64);  // 4 tiles --  Trash Container
                           break;
                    case 6: memcpy(tiles+TILESET_LENGHT,tiles_comp2,64);  // 4 tiles --  Trash Container
                            break;
                    case 7:memcpy(tiles+112,tiles_set2,16);
                           memcpy(tiles+144,tiles_set3,448);  // 24 tiles   -- Pizza store
                           break;

                    default:
                            break;

                }




}

void draw_tilemap()
{
    int index;
    unsigned char x,y,val,val1,val2,val3,val4;
    //set the tiles of the map. In this example, the tile map is 32x16 tile
    //Tile Map configuration file: TileMapConf.asm


    index=maptable_offset;
    for(y=0; y<20; y=y+2)
        {
        for (x=0; x<32; x=x+2)
        {
            val=val1=val2=val3=val4=pantallas[index];

             switch(val)
                {
                    case 0:
                    case 1:                             // Floor & Teleporters
                    case 2:
                    case 5:
                    case 51:    val1=val2=val3=val4=0;
                                break;
                    case 52:    val1=val2=val3=val4=7;
                                break;
                    case 6:    pendrive_x=x*2;
                               pendrive_y=y*8;
                               pendrive_vis=0;
                               val1=val2=val3=val4=0;
                                break;


                    case 11:    val1=val2=val3=val4=1;  // Solid wall A
                                break;

                    case 12:    val1=val2=val3=val4=2;  // Solid wall B
                                break;
                    case 13:    val1=val2=val3=val4=13;   // Solid test
                                break;

                    case 14:    val1=7;  //mesa Iz + Portatil
                                val2=8;
                                val3=3;
                                val4=4;
                                break;

                    case 15:    val1=9;  //mesa De + Sobremesa
                                val2=10;
                                val3=5;
                                val4=6;
                                break;

                    case 16:    val1=9;  //mesa Iz + Sobremesa
                                val2=10;
                                val3=3;
                                val4=4;
                                break;

                    case 17:    val1=7; //mesa De + Portatil
                                val2=8;
                                val3=5;
                                val4=6;
                                break;

                    case 18:    val1=11;  //mesa Iz + Plasmon
                                val2=12;
                                val3=3;
                                val4=4;
                                break;

                    case 19:    val1=11;  //mesa De + Plasmon
                                val2=12;
                                val3=5;
                                val4=6;
                                break;

                    case 21:    val1=13;
                                val2=14;
                                val3=15;
                                val4=16;
                                break;

                    case 22:    val1=17;
                                val2=18;
                                val3=19;
                                val4=20;
                                break;

                    case 23:    val1=21;
                                val2=22;
                                val3=23;
                                val4=24;
                                break;

                    case 24:    val1=25;
                                val2=26;
                                val3=27;
                                val4=28;
                                break;

                    case 25:    val1=29;
                                val2=30;
                                val3=31;
                                val4=32;
                                break;
                    case 26:    val1=1;
                                val2=16;
                                val3=1;
                                val4=1;
                                break;

                    case 27:    val1=0;
                                val2=0;
                                val3=17;
                                val4=0;
                                break;

                    case 28:    val1=27;
                                val2=1;
                                val3=1;
                                val4=1;
                                break;

                    case 29:    val1=0;
                                val2=0;
                                val3=0;
                                val4=22;
                                break;
                    case 31:    val1=15;
                                val2=16;
                                val3=17;
                                val4=18;
                                break;
                    case 8:    val1=0;
                                val2=19;
                                val3=0;
                                val4=20;
                                break;
                    case 32:    val1=21;
                                val2=22;
                                val3=23;
                                val4=24;
                                break;
                    case 9:    val1=25;
                                val2=0;
                                val3=26;
                                val4=0;
                                break;
                    case 33:    val1=13;
                                val2=13;
                                val3=14;
                                val4=14;
                                break;
                    case 34:    val1=13;
                                val2=13;
                                val3=13;
                                val4=13;
                                break;
                    case 35:    val1=33;
                                val2=33;
                                val3=34;
                                val4=34;
                                break;
                    case 36:    val1=35;
                                val2=35;
                                val3=36;
                                val4=36;
                                break;
                    case 37:    val1=27;
                                val2=35;
                                val3=28;
                                val4=36;
                                break;
                    case 40:    val1=33;
                                val2=34;
                                val3=35;
                                val4=36;
                                break;
                    case 41:    val1=9;
                                val2=10;
                                val3=11;
                                val4=12;
                                break;
                    case 55:    val1=4;
                                val2=4;
                                val3=4;
                                val4=4;
                                break;
                    case 56:    val1=3;
                                val2=3;
                                val3=3;
                                val4=3;
                                break;
                    case 57:    val1=5;
                                val2=5;
                                val3=5;
                                val4=5;
                                break;
                    case 58:    val1=6;
                                val2=7;
                                val3=8;
                                val4=9;
                                break;
                    case 59:    val1=1;
                                val2=1;
                                val3=0;
                                val4=0;
                                break;
                    case 60:    val1=0;
                                val2=0;
                                val3=1;
                                val4=1;
                                break;
                    case 61:    val1=17;
                                val2=18;
                                val3=19;
                                val4=20;
                                break;
                    case 62:    val1=19;
                                val2=20;
                                val3=19;
                                val4=20;
                                break;
                    case 63:    val1=21;
                                val2=22;
                                val3=23;
                                val4=24;
                                break;
                    case 64:    val1=25;
                                val2=26;
                                val3=27;
                                val4=28;
                                break;
                    case 65:    val1=27;
                                val2=28;
                                val3=27;
                                val4=28;
                                break;
                    case 66:    val1=29;
                                val2=30;
                                val3=31;
                                val4=32;
                                break;
                    case 67:    val1=10;
                                val2=10;
                                val3=5;
                                val4=5;
                                break;




               }


            cpc_SetTile(x,y,val1);
            cpc_SetTile(x+1,y,val2);
            cpc_SetTile(x,y+1,val3);
            cpc_SetTile(x+1,y+1,val4);
            index++;
        }
    }


}



void datatiles(void)
{
__asm

// Tiles de 2x8 bytes

_tiles_set1: //Party place   -- 13 tiles (0-12)
;tile 0  //suelo Azul
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0

;tile 1 //pared horizontal
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

;tile 2 //pared vertical
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44

;tile 3 //A21 MESAizqu1
.db  #0xC0,#0xE8
.db  #0xC0,#0xAC
.db  #0xC0,#0xAC
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84
.db  #0xD4,#0x84

;tile 4 //A22 MESAizqu2
.db  #0x0C,#0xC0
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0x0C,#0x48
.db  #0xC0,#0x48
.db  #0xC0,#0x48
.db  #0xC0,#0x48

;tile 5 //B21 MESAdere1
.db #0xC0,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0x0C
.db #0x84,#0xC0
.db #0x84,#0xC0
.db #0x84,#0xC0

;tile 6 //B21 MESAdere1
.db #0xD4,#0xC0
.db #0x5C,#0xC0
.db #0x5C,#0xC0
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8
.db #0x48,#0xE8

;tile 7 //A11 Portatil
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xFC,#0xFC

;tile 8 //A12 Portatil
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xCC,#0xC0
.db  #0x6E,#0xC0
.db  #0xCC,#0xC0
.db  #0xC4,#0xC0
.db  #0xFC,#0xFC

;tile 9 //B11 PC sobremesa1
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xCC
.db #0xC0,#0x9D
.db #0xC0,#0x9D
.db #0xC0,#0xCC
.db #0xC0,#0xC4
.db #0xFC,#0xFC

;tile 10 //B12 PC sobremesa2
.db #0xC0,#0xC0
.db #0xC0,#0x4C
.db #0xCC,#0x4C
.db #0x6E,#0x4C
.db #0x6E,#0x19
.db #0xCC,#0x0C
.db #0xC8,#0x0C
.db #0xFC,#0xFC

;tile 11 //C11 Pantalla consola1
.db #0xC4,#0xCC
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xC0
.db #0xC4,#0xCC
.db #0xC0,#0xCC
.db #0xFC,#0xFC

;tile 12 //C12 Pantalla consola2
.db #0xCC,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xC0,#0xC8
.db #0xCC,#0xC8
.db #0xCC,#0x00
.db #0xFC,#0xFC

_tiles_set2: // Hall -- 13 tiles max (0-12)
;tile 0 //suelo madera
.db #0xFC,#0xEC
.db #0xFC,#0xEC
.db #0xEC,#0xFC
.db #0xEC,#0xFC
.db #0xFC,#0xEC
.db #0xFC,#0xEC
.db #0xEC,#0xFC
.db #0xEC,#0xFC

//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98
//.db #0x98,#0x98

;tile 1 //pared horizontal
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

;tile 2 //pared vertical
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44
.db #0x44,#0x44

;tile 3 //  blanco columna
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C

;tile 4 //pared madera
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74

;tile 5 // gris metal
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC

;tile 6 // Mesas 1
.db #0xFC,#0xEC
.db #0xFC,#0xEC
.db #0xEC,#0x7E
.db #0xEC,#0x7E
.db #0xAC,#0x0C
.db #0xAC,#0x0C
.db #0x4C,#0xA8
.db #0x4C,#0xA8

;tile 7 // Mesas 2
.db  #0xFC,#0xEC
.db  #0xFC,#0xEC
.db  #0xEC,#0xFC
.db  #0xE5,#0xFC
.db  #0x0C,#0x4C
.db  #0x0C,#0x4C
.db  #0x44,#0xAC
.db  #0x44,#0xAC

;tile 8 // Mesas 3
.db #0x5C,#0xA8
.db #0x0C,#0x08
.db #0x0C,#0x08
.db #0x4C,#0x08
.db #0x5C,#0x08
.db #0x5C,#0x08
.db #0x4C,#0x08
.db #0x4C,#0x08

;tile 9 // Mesas 4
.db  #0x54,#0xAC
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0xAC
.db  #0x04,#0xAC
.db  #0x04,#0xAC
.db  #0x04,#0xAC
.db  #0x04,#0xAC


;tile 10 //
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC

;tile 11 //
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74

;tile 12 //
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74
.db #0x74,#0x74

_tiles_set3: // Camping   -- 24 tiles



//TIEN5

.db #0xC0,#0x84
.db #0xC0,#0x1D
.db #0x84,#0x3F
.db #0x84,#0x3F
.db #0x84,#0x3F
.db #0x84,#0x3F
.db #0x84,#0x3F
.db #0x1D,#0x1D

.db #0x48,#0xC0
.db #0x2E,#0xC0
.db #0x3F,#0x48
.db #0x3F,#0x48
.db #0x3F,#0x48
.db #0x3F,#0x48
.db #0x3F,#0x48
.db #0x2E,#0x2E

.db #0x1D,#0x2E
.db #0x1D,#0x1D
.db #0x1D,#0x1D
.db #0x1D,#0x1D
.db #0x1D,#0x1D
.db #0x1D,#0x1D
.db #0x1D,#0x1D
.db #0x0C,#0x0C

.db #0x1D,#0x2E
.db #0x2E,#0x2E
.db #0x2E,#0x2E
.db #0x2E,#0x2E
.db #0x2E,#0x2E
.db #0x2E,#0x2E
.db #0x2E,#0x2E
.db #0x0C,#0x0C


////TIEN1

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0x84
.db  #0xC0,#0x19
.db  #0xC0,#0x19
.db  #0xC0,#0x19

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0x48,#0xC0
.db  #0x26,#0xC0
.db  #0x26,#0xC0
.db  #0x26,#0xC0

.db  #0x84,#0x33
.db  #0x84,#0x33
.db  #0x84,#0x73
.db  #0x19,#0xB3
.db  #0x19,#0xB3
.db  #0x19,#0xB3
.db  #0x19,#0xB3
.db  #0x0C,#0x0C

.db  #0x33,#0x48
.db  #0x33,#0x48
.db  #0xB3,#0x48
.db  #0x73,#0x26
.db  #0x73,#0x26
.db  #0x73,#0x26
.db  #0x73,#0x26
.db  #0x0C,#0x0C

////TIEN2

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0x84
.db  #0xC0,#0x58
.db  #0xC0,#0x58
.db  #0xC0,#0x58

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0x48,#0xC0
.db  #0xA4,#0xC0
.db  #0xA4,#0xC0
.db  #0xA4,#0xC0

.db  #0x84,#0xF0
.db  #0x84,#0xF0
.db  #0x84,#0xE5
.db  #0x58,#0xDA
.db  #0x58,#0xDA
.db  #0x58,#0xDA
.db  #0x58,#0xDA
.db  #0x0C,#0x0C

.db  #0xF0,#0x48
.db  #0xF0,#0x48
.db  #0xDA,#0x48
.db  #0xE5,#0xA4
.db  #0xE5,#0xA4
.db  #0xE5,#0xA4
.db  #0xE5,#0xA4
.db  #0x0C,#0x0C

////TIEN3A
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0x84
.db  #0xC0,#0x5C
.db  #0xC0,#0x5C
.db  #0xC0,#0x5C

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0x0C,#0x0C
.db  #0x0D,#0x0F
.db  #0x0D,#0x0F
.db  #0x0D,#0x0F

.db  #0x84,#0xFC
.db  #0x84,#0xFC
.db  #0x84,#0xBC
.db  #0x5C,#0xBC
.db  #0x5C,#0x3C
.db  #0x5C,#0x3C
.db  #0x5C,#0x3C
.db  #0x0C,#0x0C

.db  #0xAC,#0x0F
.db  #0xAC,#0x0F
.db  #0xAC,#0x0F
.db  #0xFC,#0x0D
.db  #0x7C,#0x0D
.db  #0x7C,#0x0D
.db  #0x7C,#0x0D
.db  #0x0C,#0x0C
////TIEN3 B
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0x0C,#0x0C
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F

.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0x48,#0xC0
.db  #0x0E,#0xC0
.db  #0x0E,#0xC0
.db  #0x0E,#0xC0

.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0F,#0x0F
.db  #0x0C,#0x0C

.db  #0x0F,#0x48
.db  #0x0F,#0x48
.db  #0x0F,#0x48
.db  #0x0F,#0x0E
.db  #0x0F,#0x0E
.db  #0x0F,#0x0E
.db  #0x0F,#0x0E
.db  #0x0C,#0x0C

////TIEN4


.db  #0xC0,#0x84
.db  #0xC0,#0x1D
.db  #0x84,#0x3F
.db  #0x84,#0x3F
.db  #0x84,#0x3F
.db  #0x84,#0x3F
.db  #0x84,#0x3F
.db  #0x1D,#0x1D

.db  #0x48,#0xC0
.db  #0x2E,#0xC0
.db  #0x3F,#0x48
.db  #0x3F,#0x48
.db  #0x3F,#0x48
.db  #0x3F,#0x48
.db  #0x3F,#0x48
.db  #0x2E,#0x2E

.db  #0x1D,#0x2E
.db  #0x1D,#0x1D
.db  #0x1D,#0x1D
.db  #0x1D,#0x1D
.db  #0x1D,#0x1D
.db  #0x1D,#0x1D
.db  #0x1D,#0x1D
.db  #0x0C,#0x0C

.db  #0x1D,#0x2E
.db  #0x2E,#0x2E
.db  #0x2E,#0x2E
.db  #0x2E,#0x2E
.db  #0x2E,#0x2E
.db  #0x2E,#0x2E
.db  #0x2E,#0x2E
.db  #0x0C,#0x0C


//TIEN6;;
.db #0xC0,#0x84
.db #0xC0,#0x19
.db #0x84,#0x33
.db #0x84,#0x33
.db #0x84,#0x33
.db #0x84,#0x33
.db #0x84,#0x33
.db #0x19,#0x19

.db #0x48,#0xC0
.db #0x26,#0xC0
.db #0x33,#0x48
.db #0x33,#0x48
.db #0x33,#0x48
.db #0x33,#0x48
.db #0x33,#0x48
.db #0x26,#0x26

.db #0x19,#0x26
.db #0x19,#0x19
.db #0x19,#0x19
.db #0x19,#0x19
.db #0x19,#0x19
.db #0x19,#0x19
.db #0x19,#0x19
.db #0x0C,#0x0C

.db #0x19,#0x26
.db #0x26,#0x26
.db #0x26,#0x26
.db #0x26,#0x26
.db #0x26,#0x26
.db #0x26,#0x26
.db #0x26,#0x26
.db #0x0C,#0x0C



_tiles_set4: // Restaurant   -- 13 tiles max (0-12)


/*
//_tiles_comp1:
;tile 0  //rojo
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
*/



_tiles_comp1:  //PIZZA STORE    16 tiles

//1-1
.db  #0xC0,#0x0C
.db  #0x84,#0xF0
.db  #0x58,#0xF0
.db  #0x58,#0xF0
.db  #0x0C,#0x0C
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x48,#0xD0
//1-2
.db  #0x0C,#0x0C
.db  #0xF0,#0xF0
.db  #0xF0,#0xF0
.db  #0xF0,#0xF0
.db  #0x0C,#0x0C
.db  #0xC0,#0xC0
.db  #0xF0,#0xC0
.db  #0xF0,#0xC0
//1-3
.db  #0x48,#0xC5
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x48,#0xC0
.db  #0x0C,#0x0C
//1-4
.db  #0x9E,#0xC0
.db  #0x9E,#0xC0
.db  #0xF0,#0xC0
.db  #0xB0,#0xC0
.db  #0xB0,#0xC0
.db  #0xB0,#0xC0
.db  #0xB0,#0xC0
.db  #0x0C,#0x0C

//2-1
.db  #0x0C,#0x0C
.db  #0xF0,#0xF0
.db  #0xF0,#0xF0
.db  #0xF0,#0xF0
.db  #0x0C,#0x0C
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC4

//2-2
.db  #0x0C,#0xC0
.db  #0xF0,#0x48
.db  #0xF0,#0xA4
.db  #0xF0,#0xA4
.db  #0x0C,#0x0C
.db  #0xC0,#0x84
.db  #0xC0,#0x84
.db  #0x8C,#0x8C

//2-3
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0xC0,#0xC4
.db  #0x0C,#0x0C

//2-4
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x8C,#0x8C
.db  #0x0C,#0x0C

//3-1
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0

//3-2
.db #0xF0,#0xF0
.db #0xF0,#0xA4
.db #0xF0,#0x1C
.db #0xA4,#0x78
.db #0xA4,#0x3C
.db #0x1C,#0xB4
.db #0x1C,#0x3C
.db #0x1C,#0x78

//3-3
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x58,#0xF0
.db #0x0C,#0x0C

//3-4
.db #0xA4,#0x3C
.db #0xA4,#0xB4
.db #0xF0,#0x1C
.db #0xF0,#0xA4
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0x0C,#0x0C



//3-3
.db #0xF0,#0xF0
.db #0x58,#0xF0
.db #0x2C,#0xF0
.db #0x3C,#0x58
.db #0xB4,#0x58
.db #0x3C,#0x2C
.db #0xF0,#0x2C
.db #0x3C,#0x2C

//3-4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4


//4-3
.db #0xB4,#0x58
.db #0x3C,#0x58
.db #0x2C,#0xF0
.db #0x58,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0xF0,#0xF0
.db #0x0C,#0x0C

//4-4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0xF0,#0xA4
.db #0x0C,#0x0C


_tiles_comp2:  //Container & Trash

//1-1 Container
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC1,#0xC3
.db #0x80,#0x00
.db #0xC1,#0xC3
.db #0xC1,#0x33
.db #0xC1,#0x33
.db #0xC1,#0x33

//1-2 Container
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC3,#0xC3
.db #0x00,#0x00
.db #0xC3,#0xC3
.db #0x33,#0x93
.db #0x33,#0x93
.db #0x33,#0x93

//2-1 Container
.db #0xC1,#0x33
.db #0xC1,#0x33
.db #0xC1,#0x33
.db #0xC1,#0x33
.db #0xC1,#0x33
.db #0xC1,#0xC3
.db #0xC0,#0x0C
.db #0xC0,#0x0C

//2-2 Container
.db #0x33,#0x93
.db #0x33,#0x93
.db #0x33,#0x93
.db #0x33,#0x93
.db #0x33,#0x93
.db #0xC3,#0xC3
.db #0xC0,#0x0C
.db #0xC0,#0x0C



_tiles_comp3:  //Console Stands

//1-1 xbox
.db #0x91,#0x33
.db #0x91,#0x33
.db #0x91,#0xCC
.db #0x91,#0xCC
.db #0x91,#0xCC
.db #0x91,#0xCC
.db #0x91,#0xCC
.db #0x91,#0x0C

//1-2 xbox
.db #0x0C,#0x48
.db #0x0C,#0x48
.db #0xCC,#0x48
.db #0xCC,#0x48
.db #0xCC,#0x48
.db #0xCC,#0x48
.db #0xCC,#0x48
.db #0x0C,#0x48

//2-1 xbox
.db #0x91,#0x0C
.db #0x91,#0x8C
.db #0x91,#0x8C
.db #0x91,#0x00
.db #0x91,#0x04
.db #0x91,#0x04
.db #0x91,#0x04
.db #0x91,#0x04

//2-2 xbox
.db #0x0C,#0x48
.db #0x4C,#0x48
.db #0x4C,#0x48
.db #0x00,#0x48
.db #0x08,#0x48
.db #0x08,#0x48
.db #0x08,#0x48
.db #0x08,#0x48

//1-1 PS3
.db #0x80,#0x00
.db #0x80,#0x04
.db #0x80,#0xCC
.db #0x80,#0xCC
.db #0x80,#0xCC
.db #0x80,#0xCC
.db #0x80,#0xCC
.db #0x80,#0x00

//1-2 PS3
.db #0x00,#0x40
.db #0x08,#0x40
.db #0xCC,#0x40
.db #0xCC,#0x40
.db #0xCC,#0x40
.db #0xCC,#0x40
.db #0xCC,#0x40
.db #0x00,#0x40

//2-1 PS3
.db #0x80,#0x20
.db #0x80,#0x20
.db #0x80,#0x20
.db #0xC0,#0x20
.db #0xC0,#0x10
.db #0xC0,#0x00
.db #0xC0,#0x00
.db #0xC0,#0x00

//2-2 PS3
.db #0x10,#0x40
.db #0x10,#0x40
.db #0x10,#0x40
.db #0x10,#0xC0
.db #0x20,#0xC0
.db #0x00,#0xC0
.db #0x00,#0xC0
.db #0x00,#0xC0

_tiles_comp4:  //Party main control

//Morro escenario

.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00
.db  #0x00,#0x00

//blanco borde
.db  #0xCC,#0xCC
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0x0C,#0x0C
.db  #0xCC,#0xCC

//baranda iz,,

//1
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC4
.db  #0xC0,#0xCC
.db  #0xC0,#0xCC
.db  #0xC4,#0xC4
.db  #0xC4,#0xC4
.db  #0xC4,#0xCC
//2
.db  #0xC4,#0x88
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC4,#0x88
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC4,#0x88
.db  #0xCC,#0x88
//3
.db  #0xC4,#0xC4
.db  #0xC4,#0xC4
.db  #0xC4,#0xC8
.db  #0xC4,#0xC8
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
//4
.db  #0xC8,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88

//Lat IZ
//1,3
//Usar tile 0
//2
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
.db  #0xC0,#0x88
//4
.db  #0xC0,#0xcc
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0x8C
.db  #0xC0,#0xCC

//baranda DE,,

//1
.db  #0x44,#0xC8
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC8
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC8
.db  #0x44,#0xCC
//2
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC8,#0xC0
.db  #0xCC,#0xC0
.db  #0xCC,#0xC0
.db  #0xC8,#0xC8
.db  #0xC8,#0xC8
.db  #0xCC,#0xC8
//3
.db  #0x44,#0xC4
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
//4
.db  #0xC8,#0xC8
.db  #0xC8,#0xC8
.db  #0xC4,#0xC8
.db  #0xC4,#0xC8
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0
.db  #0xC0,#0xC0

//lar DE,,
//1
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
.db  #0x44,#0xC0
//3
.db  #0xCC,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0x4C,#0xC0
.db  #0xCC,#0xC0
//2,4
//Usar tile 0
//back+org
//
.db #0x48,#0xC0
.db #0x0C,#0x84
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0xC8,#0xC4
.db #0xC8,#0xC4
.db #0x9C,#0x6C
//
.db #0x9C,#0x6C
.db #0xD8,#0xE4
.db #0x58,#0xF0
.db #0x0C,#0xA4
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C


_tiles_comp6:
//Control panel
//27
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
//28
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x84,#0x0C
.db #0xC0,#0x48
//back
//29
.db #0x48,#0xC0
.db #0x0C,#0x84
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0xCC,#0xCC

//30
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x4C,#0xCC
.db #0x0C,#0x8C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C
.db #0x0C,#0x0C





_tiles_comp7:  //aUTOBUS
//Tras 1
.db  #0xCF,#0xCF
.db  #0xDE,#0xFC
.db  #0xDE,#0xEC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC

//Tras2
.db  #0xCF,#0xCF
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED

//centro1
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC

//centro2
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xFC

//morro 1
.db  #0xDE,#0xDC
.db  #0xDE,#0xDC
.db  #0xDE,#0xEC
.db  #0xDE,#0xFC
.db  #0xDA,#0xF0
.db  #0xDE,#0xFC
.db  #0x8E,#0x0C
.db  #0x8E,#0x8C
//morro 2
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xFC,#0xED
.db  #0xF0,#0xE5
.db  #0xFC,#0xED
.db  #0x0C,#0x4D
.db  #0x4C,#0x4D

//morro 3
.db  #0x8E,#0x4C
.db  #0x8E,#0x0C
.db  #0x8E,#0x0C
.db  #0xDE,#0xFC
.db  #0xCE,#0xCC
.db  #0x8E,#0xCC
.db  #0x8E,#0xCC
.db  #0xCC,#0xCC
//morro 4
.db  #0x0C,#0x4D
.db  #0x0C,#0x4D
.db  #0x0C,#0x4D
.db  #0xFC,#0xED
.db  #0xCC,#0xCD
.db  #0xCC,#0x4D
.db  #0xCC,#0x4D
.db  #0xCC,#0xCC

//,tapa1,    //tIENDA CAMPAA
.db  #0xC0,#0xC0
.db  #0xC0,#0x80
.db  #0xC0,#0x04
.db  #0xC0,#0x04
.db  #0x80,#0x0C
.db  #0x80,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0x0C

//,tapa2,
.db  #0x40,#0xC0
.db  #0x40,#0xC0
.db  #0x88,#0xC0
.db  #0x88,#0xC0
.db  #0x8C,#0x40
.db  #0x8C,#0x40
.db  #0x8C,#0x08
.db  #0x8C,#0x08

//,cuerpo1,
.db  #0x04,#0x0C
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x4C

//,cuerpo2,
.db  #0x8C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08

//,morro1,
.db  #0x04,#0x4C
.db  #0x04,#0x4C
.db  #0x04,#0x0C
.db  #0x04,#0x08
.db  #0x04,#0x04
.db  #0x04,#0x04
.db  #0x00,#0x0C
.db  #0x00,#0x8C
//,morro2,
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x8C,#0x08
.db  #0x04,#0x08
.db  #0x08,#0x08
.db  #0x08,#0x08
.db  #0x0C,#0x00
.db  #0x4C,#0x00

//,morro3,
.db  #0x04,#0x4C
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x04,#0x0C
.db  #0x00,#0x00
//,morro4,
.db  #0x8C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x0C,#0x08
.db  #0x00,#0x00



_tiles_comp5:  //Party access stairs

// Escalera LEFT
//1-1
.db #0x4C,#0x48
.db #0x04,#0x04
.db #0xCC,#0x4C
.db #0x08,#0x04
.db #0x04,#0xCC
.db #0x00,#0x08
.db #0xCC,#0x8C
.db #0xCC,#0xCC

//1-2
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0x48,#0xC0
.db #0x04,#0xC0
.db #0x4C,#0x48
.db #0x04,#0x04
.db #0xCC,#0x4C
.db #0x08,#0x04
//2-1
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

//2-2
.db #0x04,#0xCC
.db #0x00,#0x08
.db #0xCC,#0x8C
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

//1-3
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0x48,#0xC0
.db #0x04,#0xC0

//1-4
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0


//2-3
.db #0x4C,#0x48
.db #0x04,#0x04
.db #0xCC,#0x4C
.db #0x08,#0x04
.db #0x04,#0xCC
.db #0x00,#0x08
.db #0xCC,#0x8C
.db #0xCC,#0xCC

//2-4
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0x48,#0xC0
.db #0x04,#0xC0
.db #0x4C,#0x48
.db #0x04,#0x04
.db #0xCC,#0x4C
.db #0x08,#0x04


// Escalera RIGHT

.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0

.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0x84
.db #0xC0,#0x08

.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0x84
.db #0xC0,#0x08
.db #0x84,#0x8C
.db #0x08,#0x08
.db #0x8C,#0xCC
.db #0x08,#0x04

.db #0x84,#0x8C
.db #0x08,#0x08
.db #0x8C,#0xCC
.db #0x08,#0x04
.db #0xCC,#0x08
.db #0x04,#0x00
.db #0x4C,#0xCC
.db #0xCC,#0xCC


.db #0xC0,#0xC0
.db #0xC0,#0xC0
.db #0xC0,#0x84
.db #0xC0,#0x08
.db #0x84,#0x8C
.db #0x08,#0x08
.db #0x8C,#0xCC
.db #0x08,#0x04

.db #0x84,#0x8C
.db #0x08,#0x08
.db #0x8C,#0xCC
.db #0x08,#0x04
.db #0xCC,#0x08
.db #0x04,#0x00
.db #0x4C,#0xCC
.db #0xCC,#0xCC

.db #0xCC,#0x08
.db #0x04,#0x00
.db #0x4C,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC

.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC
.db #0x00,#0x00
.db #0x00,#0x00
.db #0xCC,#0xCC
.db #0xCC,#0xCC


__endasm;

}


